﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using QLCHMP_63130791.Models;

namespace QLCHMP_63130791.Areas.Admin_63130791.Controllers
{
    public class Admin_63130791Controller : Controller
    {
        private QLCHMP_63130791Entities db = new QLCHMP_63130791Entities();
        public ActionResult Login()
        {
            return View();
        }
        [HttpPost]
        public ActionResult Login(string username, string password)
        {
            if (string.IsNullOrEmpty(username) == true || String.IsNullOrEmpty(password) == true)
            {
                ViewBag.TB = "Thông Tin Đăng Nhập Không Được Để Trống";
                return View();
            }
            quantri ad = db.quantris.Find(username);
            if (ad == null)
            {
                ViewBag.TB = "Tài khoản không tồn tại";
                return View();
            }
            else ViewBag.username = username;
            if (password != ad.password)
            {
                ViewBag.TB = "Mật khẩu không đúng";
                return View();
            }
            Session["tenadmin"] = ad.hoten;
            return RedirectToAction("Index", new { masp = "", tensp = "" });
        }
        string LayMaSP()
        {
            var maMax = db.sanphams.ToList().Select(n => n.masp).Max();
            int maSP = int.Parse(maMax.Substring(2)) + 1;
            string SP = String.Concat("00", maSP.ToString());
            return "SP" + SP.Substring(maSP.ToString().Length - 1);
        }
        // GET: Admin_63130791
        [HttpGet]
        public ActionResult Index(string masp = "", string tensp = "")
        {
            if (Session["tenadmin"] != null && !string.IsNullOrEmpty(Session["tenadmin"].ToString()))
            {
                ViewBag.masp = masp;
                ViewBag.tensp = tensp;
                var sanphams = db.sanphams.SqlQuery("sanphamAdmin_timkiem'" + masp + "',N'" + tensp + "'");
                if (sanphams.Count() == 0)
                {
                    ViewBag.TB = "Không có thông tin tìm kiếm.";
                    return View(db.sanphams.ToList());
                }
                return View(sanphams.ToList());
            }
            else return RedirectToAction("Login");
        }

        // GET: Admin_63130791/Details/5
        public ActionResult Details(string id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            sanpham sanpham = db.sanphams.Find(id);
            if (sanpham == null)
            {
                return HttpNotFound();
            }
            return View(sanpham);
        }

        // GET: Admin_63130791/Create
        public ActionResult Create()
        {
            ViewBag.masp = LayMaSP();
            return View();
        }

        // POST: Admin_63130791/Create
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "tensp,imgsp,soluong,giasp,dungtich,thuonghieu,xuatxu,chitietsp")] sanpham sanpham)
        {
            //System.Web.HttpPostedFileBase Avatar;
            var imgsp = Request.Files["imgsp"];
            //Lấy thông tin từ input type=file có tên Avatar
            string postedFileName = System.IO.Path.GetFileName(imgsp.FileName);
            //Lưu hình đại diện về Server
            var path = Server.MapPath("/Images/" + postedFileName);
            imgsp.SaveAs(path);

            if (ModelState.IsValid)
            {
                sanpham.masp = LayMaSP();
                sanpham.imgsp = postedFileName;
                db.sanphams.Add(sanpham);
                db.SaveChanges();
                return RedirectToAction("Index", new {masp = sanpham.masp, tensp = sanpham.tensp});
            }


            return View(sanpham);
        }

        // GET: Admin_63130791/Edit/5
        public ActionResult Edit(string id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            sanpham sanpham = db.sanphams.Find(id);
            if (sanpham == null)
            {
                return HttpNotFound();
            }
            return View(sanpham);
        }

        // POST: Admin_63130791/Edit/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for 
        // more details see https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "masp,tensp,imgsp,soluong,giasp,dungtich,thuonghieu,xuatxu,chitietsp")] sanpham sanpham)
        {
            var imgsp = Request.Files["imgsp"];
            try
            {
                //Lấy thông tin từ input type=file có tên Avatar
                string postedFileName = System.IO.Path.GetFileName(imgsp.FileName);
                //Lưu hình đại diện về Server
                var path = Server.MapPath("/Images/" + postedFileName);
                imgsp.SaveAs(path);
            }
            catch
            { }
            if (ModelState.IsValid)
            {
                db.Entry(sanpham).State = EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index", new { masp = sanpham.masp, tensp = sanpham.tensp });
            }
            return View(sanpham);
        }

        // GET: Admin_63130791/Delete/5
        public ActionResult Delete(string id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            sanpham sanpham = db.sanphams.Find(id);
            if (sanpham == null)
            {
                return HttpNotFound();
            }
            return View(sanpham);
        }

        // POST: Admin_63130791/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(string id)
        {
            sanpham sanpham = db.sanphams.Find(id);
            db.sanphams.Remove(sanpham);
            db.SaveChanges();
            return RedirectToAction("Index", new {masp = "", tensp = ""});
        }

        public ActionResult Duyetdon()
        {
            if (Session["tenadmin"] != null && !string.IsNullOrEmpty(Session["tenadmin"].ToString()))
            {
                var don = db.Database.SqlQuery<duyetdon>("duyetdon");
                return View(don.ToList());
            }
            else return RedirectToAction("Login");
        }
        public ActionResult DuyetdonBymakh(string makh)
        {
            var don = db.dondathangs.Where(d => d.makh == makh).ToList();
            foreach (var d in don)
            {
                d.duyet = true;
            }
            db.SaveChanges();
            return RedirectToAction("Duyetdon");
        }
        public ActionResult xoadon(string madon)
        {
            var donHang = db.dondathangs.Find(madon);

            if (donHang != null)
            {
                var chiTietDonHangs = db.ct_dondathang.Where(ct => ct.madon == madon).ToList();
                db.ct_dondathang.RemoveRange(chiTietDonHangs);
                db.dondathangs.Remove(donHang);
                db.SaveChanges();
            }
            return RedirectToAction("Duyetdon");
        }
        public ActionResult xoatoanbo(string makh)
        {
            var don = db.dondathangs.Where(d => d.makh == makh).ToList();
            foreach (var d in don)
            {
                db.dondathangs.Remove(d);
                var chiTietDonHangs = db.ct_dondathang.Where(ct => ct.madon == d.madon).ToList();
                db.ct_dondathang.RemoveRange(chiTietDonHangs);
                db.SaveChanges();
            }
            return RedirectToAction("Duyetdon");
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
